/*
Half-Life MAP viewing utility.
Copyright (C) 2003  Ryan Samuel Gregg

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#pragma once

__gc class CCamera
{
private:
	Vertex3f vPosition;
	Vertex3f vLookAt;
	Vertex3f vUp;
	Vertex2f vAngle;

	float fTimeElapsed;
	long lLastTick;

	float fFPS;
	long lLastFPSUpdateTick;
	long lFrames;
	float fFrameInterval;

	//long lFreq;

	bool bInvertCamera;

public:
	CCamera();

	inline float GetFPS()
	{
		return fFPS;
	}

	void InitializePerformanceCounter();
	void UpdateTimeElapsed();

	void MoveCameraAngles(int iAngleX, int iAngleY);
	void MoveCamera(float fWalk, float fStrafe);
	void CalculateLookAt();

	void SetCamera();

	void Reset();
};